/*
 * Decompiled with CFR 0.152.
 */
package com.example.worldresetmod;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class DeletionDiagnosticUtil {
    public static String analyzeDeletionFailure(File file) {
        String path;
        StringBuilder analysis = new StringBuilder();
        analysis.append("=== DELETION FAILURE ANALYSIS ===\n");
        if (file == null) {
            analysis.append("ERROR: File object is null\n");
            return analysis.toString();
        }
        analysis.append("File: ").append(file.getAbsolutePath()).append("\n");
        analysis.append("\n1. BASIC FILE PROPERTIES:\n");
        analysis.append("   Exists: ").append(file.exists()).append("\n");
        analysis.append("   Is file: ").append(file.isFile()).append("\n");
        analysis.append("   Is directory: ").append(file.isDirectory()).append("\n");
        analysis.append("   Is hidden: ").append(file.isHidden()).append("\n");
        analysis.append("   Length: ").append(file.length()).append(" bytes\n");
        analysis.append("\n2. PERMISSION ANALYSIS:\n");
        analysis.append("   Can read: ").append(file.canRead()).append("\n");
        analysis.append("   Can write: ").append(file.canWrite()).append("\n");
        analysis.append("   Can execute: ").append(file.canExecute()).append("\n");
        analysis.append("\n3. DETAILED NIO PERMISSIONS:\n");
        try {
            BasicFileAttributes attrs = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            analysis.append("   Creation time: ").append(attrs.creationTime()).append("\n");
            analysis.append("   Last modified: ").append(attrs.lastModifiedTime()).append("\n");
            analysis.append("   Last accessed: ").append(attrs.lastAccessTime()).append("\n");
            analysis.append("   Is symbolic link: ").append(attrs.isSymbolicLink()).append("\n");
            analysis.append("   Is regular file: ").append(attrs.isRegularFile()).append("\n");
        }
        catch (IOException e) {
            analysis.append("   ERROR: Could not read NIO attributes: ").append(e.getMessage()).append("\n");
        }
        analysis.append("\n4. FILE LOCKING ANALYSIS:\n");
        boolean isLocked = DeletionDiagnosticUtil.isFileLocked(file);
        analysis.append("   File is locked: ").append(isLocked).append("\n");
        if (isLocked) {
            analysis.append("   This suggests another process has the file open.\n");
            analysis.append("   Potential solutions:\n");
            analysis.append("   - Close applications that might be using the file\n");
            analysis.append("   - Restart Windows Explorer\n");
            analysis.append("   - Use process monitoring tools to identify the locking process\n");
        }
        analysis.append("\n5. SECURITY CONTEXT:\n");
        try {
            analysis.append("   Absolute path: ").append(file.getAbsolutePath()).append("\n");
            analysis.append("   Canonical path: ").append(file.getCanonicalPath()).append("\n");
            analysis.append("   Parent exists: ").append(file.getParentFile() != null && file.getParentFile().exists()).append("\n");
            if (file.getParentFile() != null) {
                analysis.append("   Parent can read: ").append(file.getParentFile().canRead()).append("\n");
                analysis.append("   Parent can write: ").append(file.getParentFile().canWrite()).append("\n");
                analysis.append("   Parent can execute: ").append(file.getParentFile().canExecute()).append("\n");
            }
        }
        catch (IOException e) {
            analysis.append("   ERROR: Could not analyze security context: ").append(e.getMessage()).append("\n");
        }
        analysis.append("\n6. SYSTEM INFORMATION:\n");
        analysis.append("   Operating system: ").append(System.getProperty("os.name")).append("\n");
        analysis.append("   User home: ").append(System.getProperty("user.home")).append("\n");
        analysis.append("   Temp directory: ").append(System.getProperty("java.io.tmpdir")).append("\n");
        analysis.append("   User name: ").append(System.getProperty("user.name")).append("\n");
        analysis.append("\n7. COMMON CAUSES AND SOLUTIONS:\n");
        if (!file.canWrite()) {
            analysis.append("   - File is read-only or protected\n");
            analysis.append("   - Solution: Run as administrator or modify file permissions\n");
        }
        if (isLocked) {
            analysis.append("   - File is locked by another process\n");
            analysis.append("   - Solution: Close the locking process or restart system\n");
        }
        if (file.isHidden()) {
            analysis.append("   - File is hidden\n");
            analysis.append("   - Solution: Make file visible and try deletion again\n");
        }
        if (file.getAbsolutePath().contains("Program Files") || file.getAbsolutePath().contains("Windows\\System32")) {
            analysis.append("   - File is in protected system directory\n");
            analysis.append("   - Solution: Administrator privileges required\n");
        }
        if ((path = file.getAbsolutePath()).length() > 260) {
            analysis.append("   - File path exceeds Windows MAX_PATH (260 characters)\n");
            analysis.append("   - Solution: Use extended-length paths or move file to shorter path\n");
        }
        analysis.append("\n=== END ANALYSIS ===\n");
        return analysis.toString();
    }

    /*
     * Exception decompiling
     */
    private static boolean isFileLocked(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getSystemInfo() {
        String[] relevantVars;
        StringBuilder info = new StringBuilder();
        info.append("=== SYSTEM INFORMATION ===\n");
        info.append("OS: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append("\n");
        info.append("Architecture: ").append(System.getProperty("os.arch")).append("\n");
        info.append("Java Version: ").append(System.getProperty("java.version")).append("\n");
        info.append("Java Vendor: ").append(System.getProperty("java.vendor")).append("\n");
        info.append("User: ").append(System.getProperty("user.name")).append("\n");
        info.append("Home: ").append(System.getProperty("user.home")).append("\n");
        info.append("Working Directory: ").append(System.getProperty("user.dir")).append("\n");
        info.append("Temp Directory: ").append(System.getProperty("java.io.tmpdir")).append("\n");
        info.append("\n=== FILE SYSTEM INFO ===\n");
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            info.append("Temp Directory Path: ").append(tempDir.getAbsolutePath()).append("\n");
            info.append("Temp Directory Exists: ").append(tempDir.exists()).append("\n");
            info.append("Temp Directory Readable: ").append(tempDir.canRead()).append("\n");
            info.append("Temp Directory Writable: ").append(tempDir.canWrite()).append("\n");
            info.append("Temp Directory Executable: ").append(tempDir.canExecute()).append("\n");
        }
        info.append("\n=== ENVIRONMENT VARIABLES ===\n");
        for (String var : relevantVars = new String[]{"PATH", "USERNAME", "USERPROFILE", "APPDATA", "PROGRAMDATA"}) {
            String value = System.getenv(var);
            if (value != null) {
                info.append(var).append(": ").append(value).append("\n");
                continue;
            }
            info.append(var).append(": Not set\n");
        }
        info.append("\n=== PROCESS INFORMATION ===\n");
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/c", "whoami /groups");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                info.append(line).append("\n");
            }
            process.waitFor();
        }
        catch (Exception e) {
            info.append("Could not get process information: ").append(e.getMessage()).append("\n");
        }
        info.append("=== END SYSTEM INFO ===\n");
        return info.toString();
    }

    public static List<String> analyzePotentialLockingProcesses() {
        String[] commonProcesses;
        ArrayList<String> potentialProcesses = new ArrayList<String>();
        for (String processName : commonProcesses = new String[]{"javaw.exe", "java.exe", "MinecraftLauncher.exe", "explorer.exe", "svchost.exe", "System", "Registry", "smss.exe", "csrss.exe", "wininit.exe"}) {
            potentialProcesses.add(processName);
        }
        return potentialProcesses;
    }

    public static String getManualDeletionGuidance(File file) {
        StringBuilder guidance = new StringBuilder();
        guidance.append("=== MANUAL DELETION GUIDANCE ===\n");
        guidance.append("File: ").append(file.getAbsolutePath()).append("\n");
        guidance.append("\nIf automatic deletion fails, try these manual steps:\n");
        guidance.append("\n1. IMMEDIATE ACTIONS:\n");
        guidance.append("   - Close all applications that might be using the file\n");
        guidance.append("   - End any Minecraft-related processes\n");
        guidance.append("   - Wait a few seconds and try again\n");
        guidance.append("\n2. ADMINISTRATOR PRIVILEGES:\n");
        guidance.append("   - Right-click on File Explorer\n");
        guidance.append("   - Select 'Run as administrator'\n");
        guidance.append("   - Navigate to: ").append(file.getAbsolutePath()).append("\n");
        guidance.append("   - Delete the file manually\n");
        guidance.append("\n3. COMMAND LINE (as Administrator):\n");
        guidance.append("   - Open Command Prompt as Administrator\n");
        guidance.append("   - Run: del /F /Q \"").append(file.getAbsolutePath()).append("\"\n");
        guidance.append("   - If that fails, run: takeown /f \"").append(file.getAbsolutePath()).append("\"\n");
        guidance.append("   - Then run: icacls \"").append(file.getAbsolutePath()).append("\" /grant %USERNAME%:F\n");
        guidance.append("   - Finally run: del /F /Q \"").append(file.getAbsolutePath()).append("\"\n");
        guidance.append("\n4. THIRD-PARTY TOOLS:\n");
        guidance.append("   - Use tools like 'Unlocker' or 'Process Explorer'\n");
        guidance.append("   - These can identify and close file handles\n");
        guidance.append("\n5. SYSTEM RESTART:\n");
        guidance.append("   - Last resort: Restart Windows\n");
        guidance.append("   - This should release any file locks\n");
        guidance.append("\n6. SAFE MODE:\n");
        guidance.append("   - Boot Windows in Safe Mode\n");
        guidance.append("   - Try deleting the file from there\n");
        guidance.append("\n=== END MANUAL GUIDANCE ===\n");
        return guidance.toString();
    }
}

